// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Cells.subproj/OHImageCell.h,v 1.9 1999/06/19 00:50:30 kc Exp $

#import "OHBasicCell.h"

@class NSColor, NSFont, NSImage, NSView;
@class OHHTMLAnchor, OHHTMLView;

@interface OHImageCell : OHBasicCell
{
    OHHTMLAnchor *link;
    NSImage *cellImage;
    NSSize naturalSize; // The original image size
    unsigned int borderWidth;
}

- (NSImage *)image;
    // Must be called before any layout, does not schedule layout.
- (void)setImage:(NSImage *)newImage;

- (void)setImageSize:(NSSize)newSize;
- (void)setBorderWidth:(unsigned int)aBorderWidth;
- (unsigned int)borderWidth;
- (NSRect)contentFrameWithoutBorder;

@end

@interface OHImageCell (SubclassesOnly)

- (NSColor *)borderColor;
- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(OHHTMLView *)aView;
- (void)startDragFromView:(OHHTMLView *)aView event:(NSEvent *)event;

@end
