// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/View.subproj/OHHTMLView.h,v 1.27 1999/07/19 01:16:16 kc Exp $

#import <AppKit/NSView.h>

@class NSAttributedString, NSLayoutManager, NSTextContainer;
@class OWAddress, OHBreak, OHHTMLAnchor, OHHTMLOwner, OHHTMLPageView;
@class OFStaticArray;
@class NSCursor;

#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <AppKit/NSTextView.h> // For NSSelectionGranularity, NSSelectionAffinity
#import <OmniAppKit/OAFindControllerTargetProtocol.h>

#import <OIF/OIImageObserverProtocol.h>
#import <OWF/OWTargetProtocol.h>

#import "OHBasicCell.h"
#import "OHHTMLPageContentProtocol.h"
#import "OHHTMLTextViewWithBackgroundImageProtocol.h"
#import "OHManyToolTipViewProtocol.h"
#import "OHWidthRange.h"

@interface OHHTMLView : NSView <OHHTMLPageContent, OWTarget, OIImageObserver, OHHTMLTextViewWithBackgroundImage, OHManyToolTipView, OASearchableContent>
{
    OHHTMLOwner *nonretainedHTMLOwner;

    NSTextStorage *textStorage;
    NSLayoutManager *layoutManager;
    NSTextContainer *textContainer;

    NSSize textContainerInset;

    OFStaticArray *paragraphs;
    OFStaticArray *words;
    OFStaticArray *lines;
    OFStaticArray *lays;

    NSMutableArray *marginalCells;
    unsigned int firstUnlaidMarginalCellIndex;

    NSMutableArray *clearBreakObjects;

    NSSelectionGranularity selectionGranularity;
    NSRange selectedRange;

    NSColor *backgroundColor;
    OWAddress *backgroundImageAddress;
    OIImage *backgroundOmniImage;
    NSImage *backgroundImage;

    struct {
        unsigned int selectedRangeContainsMultipleFonts:1;
        unsigned int selectedRangeChangedSinceLastFontCalculation:1;
        unsigned int needsRelayout:1;
        unsigned int usesOwnBackgroundColor:1;
        unsigned int cachedWidthRangeIsValid:1;
        unsigned int selectionHoldingCellIsMarginal:1;
        unsigned int shouldAntialiasText:1;
        unsigned int isDrawingToScreen:1;
        unsigned int currentlyAntialiased:1;
        unsigned int marginSizeIsAuthoritative:1;
    } flags;

    float requiredWidth;
    OHWidthRange cachedWidthRange;

    NSPoint draggingStartingLocationInWindow;

    NSMutableSet *trackingRects;

    unsigned int selectionHoldingCellIndexHint;
}

+ (NSCursor *)linkCursor;

// API
- (void)setHTMLOwner:(OHHTMLOwner *)anHTMLOwner;
- (OHHTMLOwner *)htmlOwner;
- (unsigned int)glyphIndexForPoint:(NSPoint)point fractionOfDistanceThroughGlyph:(float *)fraction isReallyOnGlyph:(BOOL *)isReallyOnGlyph;
- (const NSRect *)rectArrayForCharacterRange:(NSRange)characterRange rectCount:(unsigned int *)returnRectCountPtr;
- (const NSRect *)rectArrayForLayRange:(NSRange)layRange rectCount:(unsigned int *)returnRectCountPtr;
- (NSRect)containingRectForCharacterRange:(NSRange)characterRange;
- (NSRect)containingRectForLayRange:(NSRange)layRange;
- (void)setNeedsDisplayForCharacterRange:(NSRange)characterRange;
- (void)scrollCharacterRangeToTop:(NSRange)characterRange;
- (void)scrollCharacterRangeToVisible:(NSRange)characterRange;
- (void)scrollCellToTop:(OHBasicCell *)aCell;
- (void)scrollCellToVisible:(OHBasicCell *)aCell;
- (void)redisplayCell:(OHBasicCell *)aCell;
- (void)relayoutCell:(OHBasicCell *)aCell;
- (void)dragAddress:(OWAddress *)anAddress event:(NSEvent *)mouseDown;
- (void)dragAnchor:(OHHTMLAnchor *)anAnchor event:(NSEvent *)mouseDown;
- (void)setMarginSize:(NSSize)newMarginSize advisory:(BOOL)isAdvisory;
- (NSSize)marginSize;

// NSTextView look-alike
- (NSString *)string;
- (void)setBackgroundColor:(NSColor *)aColor;
- (BOOL)drawsBackground;
- (void)setTextContainerInset:(NSSize)inset;
- (NSSize)textContainerInset;
- (NSRange)selectedRange;
- (void)setSelectedRange:(NSRange)charRange;
- (void)setSelectedRange:(NSRange)charRange affinity:(NSSelectionAffinity)affinity stillSelecting:(BOOL)stillSelecting;
- (NSRange)selectionRangeForProposedRange:(NSRange)proposedSelRange granularity:(NSSelectionGranularity)granularity;
- (void)scrollRangeToVisible:(NSRange)range;

// Actions
- (IBAction)relayout:(id)sender;
- (IBAction)showSelectedLink:(id)sender;
- (IBAction)saveSelectedLink:(id)sender;
- (IBAction)newWindowWithSelectedLink:(id)sender;
- (IBAction)addSelectedLinkToBookmarks:(id)sender;
- (IBAction)jumpToSelection:(id)sender;

// Calculating dimensions
- (NSSize)pageSize;

- (OHWidthRange)widthRange;

- (void)setFrameSize:(NSSize)newSize relayout:(BOOL)shouldRelayout;
- (void)setWidth:(unsigned int)newWidth;
- (float)heightForCurrentWidth;

// Building the HTML view
- (void)appendAttributedString:(NSAttributedString *)attributedString;
- (void)setRequiredWidth:(float)aWidth;
- (void)addMarginalCell:(OHBasicCell *)cell;
- (NSArray *)marginalCells;
- (void)setValidMarginalCellCount:(unsigned int)newCount;
- (void)addClearBreakObject:(OHBreak *)breakObject;
- (NSArray *)clearBreakObjects;

// Background
- (void)setBackgroundImageAddress:(OWAddress *)anAddress;
- (BOOL)usesOwnBackgroundColor;
- (void)setUsesOwnBackgroundColor:(BOOL)newSetting;
- (void)drawBackgroundForRect:(NSRect)rect backgroundOrigin:(NSPoint)backgroundOrigin;

// Drawing help
- (void)setAntialias:(BOOL)shouldAntialias;
    // This should only be called during -drawRect:

// OHOptionalDocumentView protocol
- (NSPoint)draggingStartingLocationInWindow;

@end

// Access components of the text system

@interface OHHTMLView (TextSystemOnly)
- (NSTextStorage *)textStorage;
- (NSLayoutManager *)layoutManager;
- (NSTextContainer *)textContainer;
- (OFStaticArray *)paragraphs;
- (OFStaticArray *)words;
- (OFStaticArray *)lines;
- (OFStaticArray *)lays;
- (NSRange)characterRangeForWordRange:(NSRange)wordRange;
- (NSRange)glyphRangeForWordRange:(NSRange)wordRange;
@end

@interface OHHTMLView (SubclassesOnly)
- (void)laidOutContentsAtSize:(NSSize)contentSize;
// Background image handling
- (void)backgroundImageDidUpdate;
@end
