// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/View.subproj/OHHTMLPageView.h,v 1.7 1999/06/19 00:50:40 kc Exp $

#import "OHHTMLView.h"

@class NSLock, NSMutableArray, NSImage, NSTextStorage;
@class OIImage;
@class OWAddress, OHForm, OHHTMLAnchor, OWWebPipeline;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction
#import <Foundation/NSString.h>  /* for NSStringEncoding */
#import <OWF/OWContentProtocol.h>
//#import <OWF/OWWebPipeline.h>
#import "OHDocumentViewProtocol.h"

@interface OHHTMLPageView : OHHTMLView <OHDocumentView, OAFindControllerTarget>
{
    id <OHDocumentFrame> nonretainedFrameView;

    NSMutableArray *links;
    NSMutableArray *namedAnchors;
    OHHTMLAnchor *selectedAnchor;
}

// Actions
- (IBAction)saveAllLinkedDocuments:(id)sender;
- (IBAction)saveAllLinkedImages:(id)sender;
- (IBAction)startAnimations:(id)sender;
- (IBAction)stopAnimations:(id)sender;

// Anchors
- (void)selectAnchor:(OHHTMLAnchor *)anAnchor;
- (void)selectAnchor:(OHHTMLAnchor *)anAnchor displayInAddressWell:(BOOL)shouldDisplay;
- (OHHTMLAnchor *)selectedAnchor;

- (void)followAnchor:(OHHTMLAnchor *)anchor withModifierFlags:(unsigned int)eventFlags;

// Communicating with our frame
- (void)displayDocumentAtAddress:(OWAddress *)address;

// Adding links and named anchors
- (void)addLink:(OHHTMLAnchor *)aLink;
- (void)addNamedAnchor:(OHHTMLAnchor *)aNamedAnchor;

// Examining links and named anchors
// NB These aren't copied, so they could mutate out from under you
- (NSArray *)links;
- (NSArray *)namedAnchors;

@end
