// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/View.subproj/OHHTMLDocument.h,v 1.10 1999/06/19 00:50:39 kc Exp $

#import "OHHTMLOwner.h"

@class NSLock, NSArray, NSMutableArray;
@class OHForm, OHViewCell, OHHTMLPageView, OHColorPalette, OHInlineImageCell, OHAppletCell;
@class OWPipeline;
@class OWScriptContext, OWScriptDocumentProxy;

#import "OHDocumentProtocol.h"
#import "OHFormElementProtocol.h"

@interface OHHTMLDocument : OHHTMLOwner <OHDocument>
{
    OWContentInfo *contentInfo;

    NSLock *documentInfoLock;  /* protects "forms", "documentColorPalette", and "documentImages" */

    NSMutableArray *forms;
    OHViewCell *firstFormKeyElement;
    OHViewCell *lastFormKeyElement;

    // The document's color palette. The only reason to keep this around is that it's visible from JavaScript.
    OHColorPalette *documentColorPalette;

    // A list of the images in the document, for use by scripts.
    NSMutableArray *documentImages;

    // A list of the applets in the document, for use by scripts.
    NSMutableArray *documentApplets;

    BOOL havePostedLoadEvent;
}

- (OHHTMLPageView *)htmlPageView;

// Building the document
- (void)addForm:(OHForm *)form;
- (OHViewCell *)firstFormKeyElement;
- (OHViewCell *)lastFormKeyElement;
- (void)setPipeline:(OWPipeline *)myPipe;

// Scripting interaction
- (OWScriptDocumentProxy *)scriptProxy;
- (NSArray *)forms;
    // Returns a snapshot of the forms array
- (OHColorPalette *)colorPalette;
- (void)setColorPalette:(OHColorPalette *)aPalette;
- (NSArray *)images;
- (void)addImage:(OHInlineImageCell *)anImage;
- (NSArray *)applets;
- (void)addApplet:(OHAppletCell *)anApplet;

@end
