// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Building.subproj/OHHTMLDisplayProcessor.h,v 1.8 1999/06/19 00:50:25 kc Exp $

#import <OWF/OWSGMLProcessor.h>
#import "OWScriptInterpreterProtocol.h"

@class NSImage, NSFont;
@class OHAppletCell, OHForm, OHHTMLDocument, OHImageMapSet, OHTableBuilder, OHTextBuilder;

typedef enum {
    LABEL_NONE,
    LABEL_UNSPECIFIED,
    LABEL_UNORDERED,
    
    LABEL_NUMBERS,
    LABEL_ROMAN,
    LABEL_SMALLROMAN,
    LABEL_LETTERS,
    LABEL_SMALLLETTERS,
    
    LABEL_DISC,
    LABEL_CIRCLE,
    LABEL_SQUARE,
    LABEL_IMAGE,
} OHHTMLListLabelType;

#import "OHTextBuilderObserverProtocol.h"

@interface OHHTMLDisplayProcessor : OWSGMLProcessor <OHTextBuilderObserver>
{
    OHTextBuilder *textBuilder;
    OHHTMLDocument *htmlDocument;
    
    struct {
	unsigned int insideBodyTag:1;
	unsigned int contentAddedToPipeline:1;
        unsigned int alwaysUsePreferenceColors:1;
    } flags;

    // Lists
    int listRecursionLevel;
    OHHTMLListLabelType listLabelType;
    NSImage *bulletImage;
    int listIndex;
    int lastListFinalIndex;
    float definitionListIndent;
    
    // Tables
    OHTableBuilder *tableBuilder;

    // Forms
    OHForm *currentForm;
    NSString *currentFormSubmitHandler;
    NSString *currentFormResetHandler;

    // Image Maps
    OHImageMapSet *mapSet;
    NSString *currentMapName;
    NSMutableArray *currentShapes;

    // Applets
    OHAppletCell *currentAppletCell;

    // Script debugging
    int scriptBlockCount;

    // Cache list widths
    NSFont *cachedFont;
    float discBulletStringWidth;
    float circleBulletStringWidth;
    float squareBulletStringWidth;
    NSString *cachedPrefixString;
    float cachedPrefixStringWidth;
}

- (OHTextBuilder *)textBuilder;
- (OHTextBuilder *)setTextBuilder:(OHTextBuilder *)aTextBuilder;
- (OHHTMLDocument *)htmlDocument;

@end

@interface OHHTMLDisplayProcessor (Forms)
- (void)endForm;
@end

@interface OHHTMLDisplayProcessor (General)
- (void)endAnchor;
@end

@interface OHHTMLDisplayProcessor (ImageMaps)
- (void)endMapSet;
@end

@interface OHHTMLDisplayProcessor (Scripting)
- (OWScriptContext *)hintedScriptContext;
@end

