// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Forms.subproj/OHFormValue.h,v 1.3 1999/06/19 00:50:10 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSData;
@class OWContentType;

typedef enum {
   OHFormValueString, OHFormValueFilename,
} OHFormValueType;

@interface OHFormValue : OFObject
{
    NSString *name;
    NSString *valueString;
    OHFormValueType type;
    id extraState;
}

+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString;
+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
+ (OHFormValue *)formValueWithName:(NSString *)aName valueFilepath:(NSString *)aString;

- initWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
- initWithName:(NSString *)aName valueFilepath:(NSString *)aString;
- initWithPropertyList:plist;

- (NSString *)name;
- (OHFormValueType)type;
- (NSString *)valueString;
- extraState;

- (OWContentType *)contentType;
    // Returns the content type of the file represented by a file form element (non-file elements return nil)

- propertyList;

@end
