// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Forms.subproj/OHFormSelect.h,v 1.8 1999/06/19 00:50:09 kc Exp $

#import "OHViewCell.h"
#import "OHFormElementProtocol.h"

@class OHForm, OHFormSelectOption;

@interface OHFormSelect : OHViewCell <OHFormElement>
{
    OHForm *form;
    NSString *name;
    NSArray *options;
    NSMutableArray *selectedOptions;
    OWScriptEventHandlerHolder *eventHandlers;
    NSLock *elementStateLock; // protects options and selectedOptions
}

+ (OHFormSelect *)selectWithForm:(OHForm *)aForm name:(NSString *)aName options:(NSArray *)someOptions visibleRows:(int)aRowCount allowMultiple:(BOOL)shouldAllowMultiple;

// OHFormSelectMultiple overrides these methods
- initWithForm:(OHForm *)aForm name:(NSString *)aName options:(NSArray *)someOptions;

- (NSArray *)options;
- (NSArray *)selectedOptions;
- (void)resetSelectedOptions:(NSArray *)newSelection;

- (OHForm *)form;

@end

@interface OHFormSelect (SubclassesOnly)

- (void)updateUI;
    // Called when the selectedOptions are changed programmatically.  Must be called in the appkit thread

- (void)userDidChangeSelection;
    // Called when the selectedOptions are changed by the user

- (BOOL)allowsMultipleSelection;
    // If YES, there can be from 0..N items selected. If NO, there must be exactly 1 item selected.

@end
