// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Forms.subproj/OHFormElementProtocol.h,v 1.6 1999/06/19 00:50:08 kc Exp $

// workaround for a bug in gcc's #import
#ifndef OHFORMELEMENTPROTOCOL_H
#define OHFORMELEMENTPROTOCOL_H

#import "OWScriptResponderProtocol.h"

@class NSArray, NSString, OWContentType;
@class OWScriptEventHandlerHolder;

#import "OWScriptEvent.h" // For OWScriptEventType

@protocol OHFormElement <NSObject>

/* **** NOTE ****
   All form element methods described in this protocol must be thread safe.
*/

- (void)reset;
    // Resets the form element to its original value

    // TODO: The -reset method is redundant since it can be implemented with -resetFromFormValues: and -defaultFormValues. Eventually -reset should be eliminated. 

- (void)clear;
    // Clears the form element to an empty value (unlike -reset, which sets it to its original value).  Used to clear a radio button when another is selected.

- (NSString *)name;
    // Returns the name of the form element.  (This is currently only used to clear the value of other identically-named radio buttons when a radio button is selected.)
    // (Also used by JavaScript.)

- (NSString *)type;
    // Returns the type of the form element, eg "Button", "Checkbox", "Radio"

- (NSArray *)formValues;
    // Returns an array of OHFormValue objects to be submitted by the form

- (NSArray *)defaultFormValues;
    // Returns an array of OHFormValue objects representing the default value of the form element, i.e. what the element would be set to if reset

- (void)resetFromFormValues:(NSArray *)values;
    // Reset the form element to the value(s) it stored in this array

- (OWScriptEventHandlerHolder *)eventHandlers;
    // An object which holds the event handlers for this form element

@end

#endif /* OHFORMELEMENTPROTOCOL_H */

