// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Forms.subproj/OHForm.h,v 1.6 1999/06/19 00:50:07 kc Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSString.h> // For NSStringEncoding
#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction
#import "OWScriptResponderProtocol.h"

@class NSMutableArray;
@class OWAddress, OHFormArchive, OHFormInputButton, OHFormText, OHViewCell, OHHTMLDocument;

#import "OHFormElementProtocol.h"

@interface OHForm : OFObject
{
    OWAddress *address;
    NSString *encodingType;
    NSMutableArray *elements;
    OHFormText *firstTextElement;
    OHFormText *lastTextElement;
    OHViewCell *firstKeyElement;
    OHViewCell *lastKeyElement;
    OHHTMLDocument *nonretainedHtmlDocument;
    NSMutableDictionary *selectedRadioButtonsByName;
    NSStringEncoding stringEncoding;
    NSString *formName;
    OWScriptEventHandlerHolder *eventHandlers;
}

- (void)setAddress:(OWAddress *)anAddress;
- (void)setEncodingType:(NSString *)anEncodingType;
- (void)setStringEncoding:(NSStringEncoding)newStringEncoding;
- (void)setName:(NSString *)newName;

- (void)setHTMLDocument:(OHHTMLDocument *)newHTMLDocument;
- (OHHTMLDocument *)htmlDocument;

- (void)addFormElement:(id <OHFormElement>)formElement;
- (void)radioButtonSelected:(OHFormInputButton *)selectedButton;
// Submit and reset can be (and are) called from any thread
- (void)reset;
- (void)submit;

- (IBAction)reset:(id)sender;
- (IBAction)delayedSubmit:(id)sender;

- (OWAddress *)address;
- (NSString *)encodingType;
- (NSString *)name;
- (NSArray *)elements;
- (OHViewCell *)firstKeyElement;
- (OHViewCell *)lastKeyElement;

- (OWScriptEventHandlerHolder *)eventHandlers;

@end
