// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OHDownloader.h,v 1.4 1999/06/19 00:50:36 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSLock;
@class OWDataStream;
@class OWAddress;

#import <OWF/OWTargetProtocol.h>

@interface OHDownloader : OFObject <OWTarget>
{
    NSString *requiredFilename;
    NSString *requiredDirectoryPath;
    OWDataStream *dataStream;
    NSLock *noDataStreamYetLock;
    BOOL shouldPresent;
    BOOL shouldLaunch;
}
    // Handy little utility method.
+ (NSString *)suggestedFilenameForAddress:(OWAddress *)address;
+ (NSString *)runSavePanelOnAddress:(OWAddress *)address asFileType:(NSString *)fileType;

+ (NSString *)downloadDirectoryPath;
+ (void)downloadAddressAndPromptForFilename:(OWAddress *)address;

// Init and dealloc
+ (OHDownloader *)downloader;
+ (OHDownloader *)downloaderOpenWorkspaceOnFileFromAddress:(OWAddress *)address;
+ (OHDownloader *)downloaderDownloadingAddressNoPresent:(OWAddress *)address;

//
- (void)setRequiredFilename:(NSString *)filename;
- (void)setRequiredDirectoryPath:(NSString *)directoryPath;

- (void)setPresentsWhenFinished:(BOOL)presentFlag;
- (void)setLaunchWhenFinished:(BOOL)launchFlag;
- (NSString *)filename;
- (void)blockUntilDownloadComplete;

@end

#import "FrameworkDefines.h"

OmniHTML_EXTERN NSString *OHDownloaderStartedNotification;
    // This is posted when a download starts.
OmniHTML_EXTERN NSString *OHDownloaderFinishedNotification;
    // This is posted when a download successfully completes.
OmniHTML_EXTERN NSString *OHDownloaderAbortedNotification;
    // This is posted when a download fails.

OmniHTML_EXTERN NSString *OHDownloaderTaskHeaderName;
    // The task header string used by the downloader