// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OHDocumentViewProtocol.h,v 1.6 1999/06/19 00:50:36 kc Exp $

#ifndef _OHDocumentViewProtocolDefined_
// Doing this #ifdef/#define to avoid warnings when importing both the installed project header and the one in the source directory.
#define _OHDocumentViewProtocolDefined_

#import <Foundation/NSObject.h>

@class OWAddress, OWFrameView;

#import "OHDocumentFrameProtocol.h"

@protocol OHDocumentView <NSObject>

- (void)setFrameView:(id <OHDocumentFrame>)aFrame;
- (id <OHDocumentFrame>)frameView;

- (BOOL)wantsScrollers;
    // Whether the document wants to be displayed in a scrollview

@end

#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction

@protocol OHOptionalDocumentView <OHDocumentView>

- (IBAction)saveAs:(id)sender;

- (OWAddress *)selectedAddress;
- (void)selectNextLink;
- (void)selectPreviousLink;
- (void)selectFirstKeyView;
- (void)selectLastKeyView;
- (BOOL)followSelectedAnchor;
- (void)scrollToAnchorNamed:(NSString *)anchorName;
- (void)noDisplaySelectAnchorWithAddress:(OWAddress *)anAddress;
- (void)documentDisplayedInNewFrame;

// Dragging help
- (NSPoint)draggingStartingLocationInWindow;

@end

#endif
