// Copyright 1998-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OHDocumentFrameProtocol.h,v 1.2 1999/06/19 00:50:35 kc Exp $

#import <Foundation/NSObject.h>

@class NSEvent;
@class OWAddress;
@class OWScriptFrameProxy;

#import <Foundation/NSGeometry.h> // For NSRect

@protocol OHDocumentFrame <NSObject>

// Selecting and following links

- (void)documentViewSelectionDidChange;
    // Documents call this method when their selectedAnchor changes.

- (void)displayDocumentAtAddress:(OWAddress *)anAddress;
    // Display the document at the specified address.  Documents ask the frame to display a new address when a hypertext link is followed.

// Active frame

- (void)becomeActiveFrame;
    // When a document view becomes the first responder, it lets its frame know that it is now the active frame.
- (void)resignActiveFrame;
    // When a document view resigns from being first responder, it lets its frame know that it is no longer the active frame.

// Utility methods

- (void)drawFrameBorderForDocumentView:(NSView *)aDocumentView rect:(NSRect)aRect;
    // A document view will call this in its -drawRect: to draw the frame's highlight border over itself.

- (void)documentViewKeyDown:(NSEvent *)keyDownEvent;
    // This handles common keystrokes like arrow keys, page up, page down, etc.

// Scripting

- (OWScriptFrameProxy *)scriptProxy;

@end
