// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OHColorPalette.h,v 1.4 1999/06/19 00:50:35 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSColor;

typedef enum {
    OHColorPaletteBackgroundIndex, OHColorPaletteTextIndex,
    OHColorPaletteLinkIndex, OHColorPaletteVisitedLinkIndex, OHColorPaletteActiveLinkIndex,
    OHColorPaletteExtraIndex,
    OHColorPaletteIndexCount
} OHColorPaletteIndex;

extern const OHColorPaletteIndex OHColorPaletteFirstIndex;

@interface OHColorPalette : OFObject
{
    NSColor *colorArray[OHColorPaletteIndexCount];
    BOOL hasExtraColor;
}

+ (OHColorPalette *)defaultPalette;
+ (void)setAlwaysUsePreferenceColors:(BOOL)shouldAlwaysUsePreferenceColors;

+ (NSColor *)colorForString:(NSString *)colorString;
+ (NSString *)stringForColor:(NSColor *)color;

- (id)copy;
- (id)copyWithZone:(NSZone *)newZone;

- (NSColor *)backgroundColor;
- (NSColor *)textColor;
- (NSColor *)linkColor;
- (NSColor *)visitedLinkColor;
- (NSColor *)activeLinkColor;

- (void)setBackgroundColor:(NSColor *)aColor;
- (void)setTextColor:(NSColor *)aColor;
- (void)setLinkColor:(NSColor *)aColor;
- (void)setVisitedLinkColor:(NSColor *)aColor;
- (void)setActiveLinkColor:(NSColor *)aColor;
- (void)setExtraColor:(NSColor *)aColor;
- (void)unsetExtraColor;

- (NSColor *)anchorColor; // Just in case

- (NSColor * const *)colorArray;
- (NSColor *)colorAtColorIndex:(OHColorPaletteIndex)colorIndex;

@end

@class OWSGMLTag;

@interface OHColorPalette (ColorTag)
- (id)copyWithChangesFromTag:(OWSGMLTag *)tag
  bgColorAttributeIndex:(unsigned int)bgColorAttributeIndex
  textAttributeIndex:(unsigned int)textAttributeIndex
  linkAttributeIndex:(unsigned int)linkAttributeIndex
  vlinkAttributeIndex:(unsigned int)vlinkAttributeIndex
  alinkAttributeIndex:(unsigned int)alinkAttributeIndex;
@end
