// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Cells.subproj/OHAppletCell.h,v 1.7 1999/06/19 00:50:29 kc Exp $

#import "OHViewCell.h"

@class NSMutableSet, NSLock, NSDictionary, NSMutableDictionary;
@class OWAddress;
@class OWDocText, OHHTMLDocument;

typedef enum {
    OHAppletStatusUnloaded, OHAppletStatusLoading, OHAppletStatusReady, OHAppletStatusRunning, OHAppletStatusStopped, OHAppletStatusError
} OHAppletStatus;

#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <OWF/OWTargetProtocol.h>
#import "OHAppletControllerProtocol.h"

@interface OHAppletCell : OHViewCell <OWTarget>
{
    OHHTMLDocument *nonretainedHTMLDocument;
    NSString *appletClassName;
    OWAddress *codeBaseAddress;
    NSMutableDictionary *parameters;
    NSString *cellName;

    OHAppletStatus status;

    id <OHAppletController> appletController;
}

- initWithCode:(NSString *)name codeBaseAddress:(OWAddress *)anAddress referringAddress:(OWAddress *)aReferringAddress htmlDocument:(OHHTMLDocument *)aDocument;
    // Information from the <applet> tag

- (void)addParameter:(NSString *)name value:(NSString *)value;
    // Information from subsequent <param> tags

- (OWAddress *)codeBaseAddress;
- (OHHTMLDocument *)document;
- (NSDictionary *)parameters;

- (NSString *)name;
- (void)setName:(NSString *)appletName;

- (id <OHAppletController>)appletController;

// Actions

- (IBAction)start:(id)sender;
- (IBAction)stop:(id)sender;

@end
