// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFTrieNode.h,v 1.3 1999/03/30 22:04:40 kc Exp $

#import "OFObject.h"

#import <Foundation/NSString.h> /* For unichar */

@interface OFTrieNode : OFObject
{
@public
    unsigned int count;
    unichar *characters;
    id *children;
}

- (void)addChild:aChild withCharacter:(unichar)c;

@end

static inline unsigned int
trieFindIndex(OFTrieNode *node, unichar c)
{
    unsigned int low = 0;
    unsigned int range = 1;
    unsigned int test = 0;

    while (node->count >= range) /* range is the lowest power of 2 > count */
        range <<= 1;

    while (range) {
        test = low + (range >>= 1);
        if (test >= node->count)
            continue;
        if (node->characters[test] < c)
            low = test+1;
    }
    return low;
}

static inline id
trieFindChild(OFTrieNode *node, unichar c)
{
    unsigned int index = trieFindIndex(node, c);

    if (index < node->count && node->characters[index] == c)
	return node->children[index];
    else
	return nil;
}
