// Copyright 1998-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFStaticArray.h,v 1.7 1999/03/30 21:25:40 kc Exp $

#import "OFObject.h"

// An array of OFStaticObjects of a particular class, with efficient allocation and deallocation

#ifndef WIN32
#define OFStaticArray_USE_NSDATA
#endif

@class NSMutableData;

@interface OFStaticArray : OFObject
{
    Class objectClass;
    unsigned int objectLength;
    unsigned int count;
    unsigned int capacity;
    unsigned int extensionSize;
    void *mutableBytes;
#ifdef OFStaticArray_USE_NSDATA
    NSMutableData *data;
#endif
}

- initWithClass:(Class)aClass capacity:(unsigned int)aCapacity extendBy:(unsigned int)extendBy;
- initWithClass:(Class)aClass capacity:(unsigned int)aCapacity;
- initWithClass:(Class)aClass;

- (unsigned int)capacity;
- (void)setCapacity:(unsigned int)aCapacity;

- (unsigned int)extensionSize;
- (void)setExtensionSize:(unsigned int)anAmount;

- (unsigned int)count;
- (void)setCount:(unsigned int)number;
- (void)removeAllObjects;

- (id)newObject;
- (id)objectAtIndex:(unsigned int)anIndex;

@end
