// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/Scheduling.subproj/OFScheduler.h,v 1.7 1999/06/11 17:21:38 kc Exp $

#import "OFObject.h"

@class NSDate, NSRecursiveLock, NSMutableArray, NSTimer;
@class OFInvocation, OFScheduledEvent;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface OFScheduler : OFObject
{
    NSTimer *alarmTimer;

    NSMutableArray *scheduleQueue;
    NSRecursiveLock *scheduleLock;
}

+ (OFScheduler *)mainScheduler;

- (OFScheduledEvent *)scheduleInvocation:(OFInvocation *)anInvocation atDate:(NSDate *)date;
- (OFScheduledEvent *)scheduleInvocation:(OFInvocation *)anInvocation afterTime:(NSTimeInterval)time;

- (OFScheduledEvent *)scheduleSelector:(SEL)selector onObject:(id)anObject withObject:(id)anArgument atDate:(NSDate *)date;
- (OFScheduledEvent *)scheduleSelector:(SEL)selector onObject:(id)anObject withObject:(id)anArgument afterTime:(NSTimeInterval)time;

- (void)abortEvent:(OFScheduledEvent *)anEvent;
- (void)abortSchedule;

- (OFScheduler *)subScheduler;

@end
