// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/OFRegularExpression.h,v 1.5 1999/03/30 22:04:37 kc Exp $

#import "OFObject.h"
#import <Foundation/NSString.h>

typedef enum {
    OpEnd, OpStartOfLine, OpEndOfLine, OpAnyCharacter, OpAnyOfString, OpAnyButString, OpBranch, OpBack, OpExactlyString, OpNothing, OpZeroOrMore, OpOneOrMore, OpOpen, OpClose
} ExpressionOpCode;

typedef struct {
    ExpressionOpCode opCode	: 4;
    unsigned int argumentNumber	: 12;
    unsigned int nextState	: 16;
} ExpressionState;

@class OFStringScanner, OFRegularExpressionMatch;

@interface OFRegularExpression : OFObject
{
    NSString *patternString;
    unichar startCharacter;
    BOOL matchStartsLine;
    unichar *matchString;
    unsigned int subExpressionCount;
    ExpressionState *program;
    unichar *stringBuffer;
}

- initWithString:(NSString *)string;

- (OFRegularExpressionMatch *)matchInString:(NSString *)string;
- (OFRegularExpressionMatch *)matchInScanner:(OFStringScanner *)scanner;

- (BOOL)hasMatchInString:(NSString *)string;
- (BOOL)hasMatchInScanner:(OFStringScanner *)scanner;

@end
