// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFRandom.h,v 1.4 1999/03/30 22:04:39 kc Exp $

#import "OFObject.h"
#import "FrameworkDefines.h"

// Some platforms don't provide random number generation and of those that do, there are many different variants.  We provide a common random number generator rather than have to deal with each platform independantly.  Additionally, we allow the user to maintain several random number generators.

typedef struct {
    unsigned long y; // current value any number between zero and M-1
} OFRandomState;

OmniFoundation_EXTERN OFRandomState OFDefaultRandomState;
// This random state will automatically be seeded at startup.  This initialization will occur during +[OBPostLoader processClasses].  The default random state should not be used before this method has completed.

OmniFoundation_EXTERN void OFRandomSeed(OFRandomState *state, unsigned long y);
OmniFoundation_EXTERN unsigned long OFRandomNextState(OFRandomState *state);

#define OFRandomNext() OFRandomNextState(&OFDefaultRandomState)
