// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFQueue.h,v 1.4 1999/03/30 22:04:39 kc Exp $

#import <Foundation/NSObject.h>
#import <mach/cthreads.h>

@interface OFQueue : NSObject
{
    BOOL closed;
    id *objects;
    unsigned int max, count, head, tail;
    struct mutex mutex;
    struct condition condition;
}

- initWithCount:(unsigned int)maxCount;

- (unsigned int)maxCount;
- (unsigned int)count;

- (BOOL)isClosed;
- (void)close;

- (id)dequeueShouldWait:(BOOL)wait;
- (BOOL)enqueue:(id)anObject shouldWait:(BOOL)wait;

@end
