// Copyright 1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/OFFastCharacterSet.h,v 1.1 1999/06/18 22:32:52 bungi Exp $

#import "OFObject.h"

#import <Foundation/NSCharacterSet.h>
#import <Foundation/NSData.h>

typedef const byte *OFFastCharacterSet; // Bitmap representation of an NSCharacterSet


static inline BOOL OFFastCharacterSetContainsCharacter(OFFastCharacterSet characterSet, unichar character)
{
    return (characterSet[character >> 3] & (((unsigned int)0x1) << (character & 7)));
}

static inline OFFastCharacterSet OFFastCharacterSetForCharacterSetDoRetain(NSCharacterSet *characterSet, BOOL shouldRetain)
{
    NSData *bitmapRepresentation;

    bitmapRepresentation = [characterSet bitmapRepresentation];
    if (shouldRetain)
        [bitmapRepresentation retain];
    return [bitmapRepresentation bytes];
}



//
// Backwards compatibility
//
typedef OFFastCharacterSet CSBitmap; // Bitmap representation of an NSCharacterSet


static inline BOOL characterIsMemberOfCSBitmap(CSBitmap characterSet, unichar character)
{
    return OFFastCharacterSetContainsCharacter(characterSet, character);
}

static inline CSBitmap bitmapForCharacterSetDoRetain(NSCharacterSet *characterSet, BOOL shouldRetain)
{
    NSData *bitmapRepresentation;

    bitmapRepresentation = [characterSet bitmapRepresentation];
    if (shouldRetain)
        [bitmapRepresentation retain];
    return [bitmapRepresentation bytes];
}
