// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniFoundation/DataStructures.subproj/OFDataCursor.h,v 1.5 1999/03/30 21:25:36 kc Exp $

#import "OFObject.h"

// OFDataCursor assumes an immutable data object.

@class NSData;
@class OFByteSet;

typedef enum {
    OFDataCursorSeekFromCurrent,
    OFDataCursorSeekFromEnd,
    OFDataCursorSeekFromStart
} OFDataCursorSeekPosition;

#import "OFByteOrder.h"
#import <Foundation/NSString.h> // For NSStringEncoding

@interface OFDataCursor : OFObject
{
    NSData *data;
    OFByteOrder byteOrder;
    NSStringEncoding stringEncoding;

    unsigned int dataLength;
    const byte *startPosition, *endPosition;
    const byte *currentPosition;
}

- initWithData:(NSData *)someData;
- (void)setByteOrder:(OFByteOrder)newByteOrder;

- (BOOL)hasMoreData;
- (unsigned int)seekToOffset:(int)offset fromPosition:(OFDataCursorSeekPosition)position;
- (unsigned int)currentOffset;
- (void)rewind;

- (void)readBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (void)peekBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (void)skipBytes:(unsigned int)byteCount;

- (unsigned int)readMaximumBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (unsigned int)peekMaximumBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (unsigned int)skipMaximumBytes:(unsigned int)byteCount;

- (unsigned int)offsetToByte:(byte)aByte;
- (unsigned int)offsetToByteInSet:(OFByteSet *)aByteSet;

- (long int)readLongInt;
- (long int)peekLongInt;
- (void)skipLongInt;
- (short int)readShortInt;
- (short int)peekShortInt;
- (void)skipShortInt;
- (long long int)readLongLongInt;
- (long long int)peekLongLongInt;
- (void)skipLongLongInt;
- (float)readFloat;
- (float)peekFloat;
- (void)skipFloat;
- (double)readDouble;
- (double)peekDouble;
- (void)skipDouble;
- (byte)readByte;
- (byte)peekByte;
- (void)skipByte;

- (NSData *)readDataOfLength:(unsigned int)aLength;
- (NSData *)peekDataOfLength:(unsigned int)aLength;
- (NSData *)readDataUpToByte:(byte)aByte;
- (NSData *)peekDataUpToByte:(byte)aByte;
- (NSData *)readDataUpToByteInSet:(OFByteSet *)aByteSet;
- (NSData *)peekDataUpToByteInSet:(OFByteSet *)aByteSet;
- (NSString *)readStringOfLength:(unsigned int)aLength;
- (NSString *)peekStringOfLength:(unsigned int)aLength;
- (NSString *)readStringUpToByte:(byte)aByte;
- (NSString *)peekStringUpToByte:(byte)aByte;
- (NSString *)readStringUpToByteInSet:(OFByteSet *)aByteSet;
- (NSString *)peekStringUpToByteInSet:(OFByteSet *)aByteSet;

- (NSData *)readAllData;
- (NSString *)readLine;
- (void)skipLine;

@end
