// Copyright 1998-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAStatusDisplayer.h,v 1.3 1999/03/30 21:26:12 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OAStatusView;
@class NSView, NSWindow;

#import "OAExtraWindowDrawingProtocol.h"
#import "OAStatusViewPositionProtocol.h"

@interface OAStatusDisplayer : OFObject <OAExtraWindowDrawing>
{
    NSView <OAStatusViewPosition> *viewToDisplayOver;
    OAStatusView *statusView;
    NSWindow *statusWindow, *bufferWindow;
    struct {
        unsigned int shouldDraw:1;
    } flags;
    NSRect statusRect;
}

- initForView:(NSView <OAStatusViewPosition> *)aView;

// API
- (void)setStatus:(NSString *)aStatus;
- (void)setStatus:(NSString *)aStatus withProgress:(unsigned int)amount ofTotal:(unsigned int)total;


@end
