// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/Widgets.subproj/OAScrollView.h,v 1.8 1999/03/30 21:26:12 kc Exp $

#import <AppKit/NSScrollView.h>

@class NSButton, NSMenuItem, NSPopUpButton, NSTextField;

typedef enum { YES_SCROLL, NO_SCROLL, AUTO_SCROLL } ScrollingBehavior;

@interface OAScrollView : NSScrollView
{
    NSView                     *horizontalWidgetsBox;
    NSPopUpButton              *scalePopUpButton;
    NSButton                   *pageUpButton;
    NSButton                   *pageDownButton;
    NSTextField		       *pagePromptTextField;
    NSTextField		       *pageNumberTextField;
    NSTextField		       *pagesCountTextField;
    float                       zoomFactor;
    ScrollingBehavior           scrollBehavior;
    id			        delegate;
    struct {
        unsigned int			tiling:1;
    } flags;
}


- (void)zoomToScale:(double)newZoomFactor;
- (void)zoomFromSender:(NSMenuItem *)sender;
- (float)zoomFactor;
- (void)setDelegate:(id)newDelegate;
- (void)setScrollBehavior:(ScrollingBehavior)behavior;
- (void)showingPageNumber:(int)pageNumber of:(unsigned int)pagesCount;
- (void)gotoPage:(id)sender;

@end
