// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/Preferences.subproj/OAPreferenceController.h,v 1.7 1999/04/22 00:58:49 wiml Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSGeometry.h>

@class NSMutableArray, NSMutableDictionary;
@class NSBox, NSImageView, NSTableView, NSTextField, NSWindow;
@class OAPreferenceClient, OAPreferenceController;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *box;
    IBOutlet NSTableView *tableView;
    IBOutlet NSTextField *titleTextField;
    IBOutlet NSImageView *imageView;

    NSString *categoryName;
    OAPreferenceClient *currentClient;
    NSMutableArray *clientRecordsArray;
    NSMutableDictionary *clientClassNamesToClientRecordDictionary;
    NSMutableDictionary *clientClassNamesToInstancesDictionary;

    NSSize preferredBoxSize;
    NSSize windowExtraSize;
}

+ (OAPreferenceController *)sharedPreferenceControllerNamed:(NSString *)categoryName;
+ (OAPreferenceController *)sharedPreferenceController;

- initWithCategoryName:(NSString *)controllerCategoryName;

// API
- (void)setCurrentClientByName:(NSString *)clientName;
- (OAPreferenceClient *)clientNamed:(NSString *)clientName;
- (void)close;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)selectPreference:(NSTableView *)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
