// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/Inspector.subproj/OAInspectorProtocol.h,v 1.4 1999/03/30 21:25:57 kc Exp $

#import <Foundation/NSObject.h>

@class NSView;

@protocol OAInspector <NSObject>

- (NSString *)inspectorName;
    // Will be used as window title, with " Document" after it.

- (void)inspectObject:(id)anObject;
    // The shared OAInspector instance calls this method on your inspectable controller once your inspector view is installed to let you actually inspect the object.

- (void)redisplay;
    // Called to redisplay the inspector.

- (NSView *)inspectorView;
    // Returns the view which OAInspector will swap into the Inspector window when your object is being inspected.

@end
