// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/Inspector.subproj/OAInspector.h,v 1.7 1999/03/30 21:25:55 kc Exp $

#import <OmniBase/OBObject.h>

@class NSBox, NSView, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import "OAInspectableControllerProtocol.h"
#import "OAInspectorProtocol.h"

@interface OAInspector : OBObject
{
    IBOutlet NSWindow *inspectorWindow;
    IBOutlet NSBox *inspectorBox;
    IBOutlet NSBox *noInspectorBox;
    IBOutlet NSBox *multiInspectorBox;

    id <OAInspector, NSObject> currentInspector;
    NSView *currentInspectorView;

    BOOL isOnScreen;
}

+ (void)registerInspector:(id <OAInspector>)anInspector forClass:(Class)aClass;
+ (OAInspector *) sharedInspector;
+ (void)showInspector;

+ (id)multipleSelectionObject;

- (BOOL)isInspectorVisible;

@end

#import "FrameworkDefines.h"

OmniAppKit_EXTERN NSString *OAInspectorSelectionDidChangeNotification;
OmniAppKit_EXTERN NSString *OAInspectorShowInspectorDefaultKey;
