// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniAppKit/OAFindController.h,v 1.10 1999/07/20 13:00:18 kc Exp $

// OAFindController controls a simple find panel.

// To use, add an OAFindController object to your main nib, and hook up the appropriate menu items to its -showFindPanel:, -findNext:, -findPrevious:, and -enterSelection: actions.  (Hook up Scroll To Selection to First Responder's jumpToSelection: action.)
// The find panel will search the OAFindControllerTarget indicated by the main window's delegate's -omniFindControllerTarget method.


#import <OmniFoundation/OFObject.h>

@class NSButton, NSForm, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import "OAFindControllerTargetProtocol.h"

@interface OAFindController : OFObject
{
    IBOutlet NSWindow *findPanel;
    IBOutlet NSForm *searchTextForm;
    IBOutlet NSButton *ignoreCaseButton;
    IBOutlet NSButton *findNextButton;
    IBOutlet NSButton *findPreviousButton;
}

// Menu actions

- (IBAction)showFindPanel:(id)sender;
- (IBAction)findNext:(id)sender;
- (IBAction)findPrevious:(id)sender;
- (IBAction)enterSelection:(id)sender;

// Panel actions

- (IBAction)_findNext:(id)sender;
    // This action is sent by findNextButton
- (IBAction)_findPrevious:(id)sender;
    // This action is sent by findPreviousButton
- (IBAction)_findNextAndClosePanel:(id)sender;
    // This action is called when you hit return in searchTextForm

// Utility methods
- (void)saveFindText:(NSString *)string;
- (NSString *)restoreFindText;
- (id <OAFindControllerTarget>)target;
- (NSString *)enterSelectionString;
- (unsigned int)enterSelectionStringLength;

@end
