// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Pipelines.subproj/OWTask.h,v 1.11 1999/03/30 21:26:31 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSCountedSet, NSDate, NSLock, NSMutableArray;
@class OWContentInfo;

#import <Foundation/NSDate.h> // For NSTimeInterval
#import <OmniFoundation/OFSimpleLock.h>
#import <OmniFoundation/OFMessageQueuePriorityProtocol.h>
#import "OWAddressProtocol.h"
#import "OWPipelineInspectorProtocol.h"

typedef enum {
    PipelineInit, PipelineBuilding, PipelineRunning, PipelinePaused,
    PipelineAborting, PipelineDead
} PipelineState;

@interface OWTask : OFObject
{
    OWContentInfo *contentInfo;
    NSLock *parentContentInfoLock;
    OWContentInfo *parentContentInfo;
    
    NSDate *lastActivationDate;

    struct {
        unsigned int wasActiveOnLastCheck:1;
    } taskFlags;
    PipelineState state;

    id <OWPipelineInspector> inspector;

    OFSimpleLockType displayablesSimpleLock;
    NSString *compositeTypeString;
}

+ (NSString *)HMSStringFromTimeInterval:(NSTimeInterval)interval;

// Init and dealloc
- init;
    // Designated initializer
- initWithName:(NSString *)name contentInfo:(OWContentInfo *)aContentInfo parentContentInfo:(OWContentInfo *)aParentContentInfo;

// Task management
- (void)abortTask;

// Active tree
- (BOOL)treeHasActiveChildren;
- (void)treeActiveStatusMayHaveChanged;
- (void)activateInTree;
- (void)deactivateInTree;
- (void)abortTreeActivity;

// State
- (PipelineState)state;
- (id <OWAddress>)lastAddress;

- (NSTimeInterval)timeSinceTreeActivationInterval;
- (NSTimeInterval)estimatedRemainingTimeInterval;
- (NSTimeInterval)estimatedRemainingTreeTimeInterval;

- (BOOL)hadError;
- (BOOL)isRunning;
- (BOOL)hasThread;
- (NSString *)errorNameString;
- (NSString *)errorReasonString;

- (NSString *)compositeTypeString;
- (BOOL)hasChildrenInCompositeTypeStringsInArray:(NSMutableArray *)compositeTypeStrings andSet:(NSCountedSet *)compositeTypeStringsSet;
- (NSString *)documentsInTreeString;
    // -documentsInTreeString returns NIL if this task is active but no children are -- in that case it's a signal you should use -statusString
- (unsigned int)workDone;
- (unsigned int)workToBeDone;
- (unsigned int)workDoneIfNotFinished;
- (unsigned int)workToBeDoneIfNotFinished;
- (unsigned int)workDoneIncludingChildrenIncludingFinished:(BOOL)includeFinished;
- (unsigned int)workToBeDoneIncludingChildrenIncludingFinished:(BOOL)includeFinished;
- (NSString *)statusString;

// Inspecting
- (void)setInspector:(id <OWPipelineInspector>)newInspector;
- (void)tellInspectorPipelineTreeDidChange;

// Parent contentInfo
- (void)setParentContentInfo:(OWContentInfo *)aParentContentInfo;
- (OWContentInfo *)parentContentInfo;

// ContentInfo
- (OWContentInfo *)contentInfo;
- (void)nullifyContentInfo;

- (void)deepFlushContentCache;
    // Flushes the content cache and all its children

// OFMessageQueue protocol helpers
- (unsigned int)taskPriority;
- (unsigned int)baseTaskPriority; // Without modifiers
- (unsigned int)taskGroup;
- (unsigned int)taskMaximumSimultaneousThreadsInGroup;

- (NSComparisonResult)comparePriority:(OWTask *)aTask;

@end
