// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/Address.subproj/OWProxyServer.h,v 1.5 1999/03/30 21:26:24 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray;
@class OWURL;

@interface OWProxyServer : OFObject
{
    BOOL active;
    OWURL *proxyURL;
    NSString *description;
    NSArray *schemes;
    NSArray *destinations;
}

+ (OWURL *)proxyURLForURL:(OWURL *)aURL;
+ (NSArray *)proxyServersFromDefaults;
+ (OWProxyServer *)proxyServerWithURL:(OWURL *)aURL;

- initWithProxyURL:(OWURL *)aProxyURL;

- (OWURL *)proxyURL;
- (NSString *)description;
- (NSArray *)schemes;
- (NSArray *)destinations;
- (BOOL)isActive;

- (void)setProxyURL:(OWURL *)aProxyURL;
- (void)setDescription:(NSString *)aDescription;
- (void)setSchemes:(NSArray *)someSchemes;
- (void)setDestinations:(NSArray *)someDestinations;

- (void)activate;
- (void)deactivate;

- (BOOL)isProxyForURL:(OWURL *)aURL;

- (NSDictionary *)defaultsDictionary;

@end
