// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWObjectStreamCursor.h,v 1.5 1999/03/30 21:26:20 kc Exp $

#import "OWCursor.h"

@class OWAbstractObjectStream;

@interface OWObjectStreamCursor : OWCursor <NSCopying>
{
    OWAbstractObjectStream *objectStream;
    unsigned int streamIndex;
}

- initForObjectStream:(OWAbstractObjectStream *)anObjectStream;
- (OWAbstractObjectStream *)objectStream;
- (unsigned int)streamIndex;

- (id)readObject;
- (void)skipObjects:(int)count;
- (void)ungetObject:(id)anObject;

@end
