// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWFileInfo.h,v 1.4 1999/03/30 21:26:20 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSDate, NSNumber;
@class OWAddress;

#import "OWContentProtocol.h"

@interface OWFileInfo : OFObject <OWContent>
{
    OWAddress *address;
    NSNumber *size;
    struct {
        unsigned int isDirectory:1;
        unsigned int isShortcut:1;
    } flags;
    NSDate *lastChangeDate;

    NSString *cachedName;
}

+ (OWContentType *)contentType;

- initWithAddress:(OWAddress *)anAddress size:(NSNumber *)aSize isDirectory:(BOOL)isDirectory isShortcut:(BOOL)isShortcut lastChangeDate:(NSDate *)aDate;

// Attributes

- (OWAddress *)address;
- (NSNumber *)size;
- (BOOL)isDirectory;
- (BOOL)isShortcut;
- (NSDate *)lastChangeDate;

// Derived attributes

- (NSString *)name;
- (NSString *)addressString;

@end
