// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWDataStreamCursor.h,v 1.6 1999/03/30 21:26:19 kc Exp $

#import "OWCursor.h"

@class NSData;
@class OWDataStream;

#import "OWStringDecoderProtocol.h"

#import <OmniFoundation/OFByteOrder.h>
#import <Foundation/NSString.h> // For NSStringEncoding

@interface OWDataStreamCursor : OWCursor
{
    OWDataStream *dataStream;
    OFByteOrder byteOrder;

    unsigned int dataOffset;
    byte partialByte;
    unsigned int bitsLeft;

    NSStringEncoding stringEncoding;
    NSObject <OWStringDecoder> *stringDecoder;
}

- initForDataStream:(OWDataStream *)aStream;
- (OWDataStream *)dataStream;

- (void)setByteOrder:(OFByteOrder)newByteOrder;

- (void)skipBytes:(unsigned int)byteCount;

- (unsigned int)currentOffset;

- (void)readBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;
- (void)peekBytes:(unsigned int)byteCount intoBuffer:(void *)buffer;

- (void)bufferBytes:(unsigned int)count;
    // Ensures that 'count' bytes are buffered.

- (unsigned int)readMaximumBytes:(unsigned int)maximum intoBuffer:(void *)buffer;
    // Reads up to 'maximum' bytes into 'buffer', returns the number of bytes actually read.
- (NSData *)readData;
    // Reads the buffered bytes.
- (NSData *)peekData;
    // Peeks at the buffered bytes.

- (NSData *)readAllData;
    // Reads all remaining data.

- (NSData *)readBytes:(unsigned int)byteCount;
- (NSData *)peekBytes:(unsigned int)byteCount;

- (byte)readByte;
- (byte)peekByte;
- (int)readInt;
- (int)peekInt;
- (short)readShort;
- (short)peekShort;
- (long)readLong;
- (long)peekLong;
- (long long)readLongLong;
- (long long)peekLongLong;
- (float)readFloat;
- (float)peekFloat;
- (double)readDouble;
- (double)peekDouble;

- (unsigned int)readBits:(unsigned int)number;
- (int)readSignedBits:(unsigned int)number;
- (void)skipToNextFullByte;

// For reading unusual encodings
- (void)setStringDecoder:(NSObject <OWStringDecoder> *)decoder;
- (NSObject <OWStringDecoder> *)stringDecoder;
- (void)setStringEncoding:(NSStringEncoding)encoding;
- (NSStringEncoding)stringEncoding;

- (NSString *)readString;

- (NSString *)readLine;
- (NSString *)peekLine;
- (void)skipLine;

- (NSString *)readToken;
- (NSString *)peekToken;

- (int)readTextInt;
- (int)peekTextInt;

- (unsigned)scanUntilByte:(byte)byteMatch;
    // Positions the offset _before_ the byte.  Should be named -scanUpToByte:.  Also, it's currently quite surprisingly slow (because we usually use the heavily optimized OWDataStreamScanner instead).
- (unsigned)scanUntilByteSet:(NSCharacterSet *)byteMatch;
    // Like -scanUntilByte:, but scans for any bytes in the specified set.  This should take an OFByteSet rather than an NSCharacterSet.

- (unsigned)scanUntilStringRead:(NSString *)stringMatch;
    // Positions the offset _after_ the string.  Should be named -scanPastString:

@end

#import "FrameworkDefines.h"

OWF_EXTERN NSException *OWDataStreamCursor_UnderflowException;
OWF_EXTERN NSException *OWDataStreamCursor_EndOfDataException;
