// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWCursor.h,v 1.6 1999/03/30 21:26:18 kc Exp $

#import "OWAbstractContent.h"

@class NSException;

typedef enum {
    OWCursorSeekFromCurrent,
    OWCursorSeekFromEnd,
    OWCursorSeekFromStart
} OWCursorSeekPosition;

@interface OWCursor : OWAbstractContent
{
    NSException *abortException;
}

- initFromCursor:(id)aCursor;
- (id)newCursor;

- (unsigned int)seekToOffset:(int)offset fromPosition:(OWCursorSeekPosition)position;
- (void)abortWithException:(NSException *)anException;
- (void)abort;
    // Calls -abortWithException: passing userAbortException as the exception

@end
