// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWContentProtocol.h,v 1.7 1999/05/05 05:12:19 wiml Exp $

#ifndef OWContentProtocolHeader
#define OWContentProtocolHeader

#import <Foundation/NSObject.h>

@class OWContentInfo, OWContentType, OWCursor;

@protocol OWContent <NSObject>

- (OWContentType *)contentType;
    // Returns the content type (e.g., text/html) for this content

- (OWContentInfo *)contentInfo;
    // NOTE: Implementors MUST call [contentInfo nullifyContent] before they are dealloc'd, or contentInfo will crash.  ContentInfo does NOT retain the content, and thus needs to know when it goes away.
@end

@protocol OWOptionalContent <NSObject>
- (OWCursor *)contentCursor;
- (unsigned long int)cacheSize;
- (BOOL)shareable;
- (BOOL)contentIsValid;

// Called when a non-shareable content is about to be returned to the cache. Gives the content a chance to clean up. If the method returns NO, the content is discarded instead of recached.
- (BOOL)prepareForReturnToCache;
@end

#endif
