// Copyright 1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OWF/Content.subproj/OWCompoundObjectStream.h,v 1.3 1999/03/30 21:26:17 kc Exp $

#import "OWAbstractObjectStream.h"

@class OWObjectStreamCursor;

@interface OWCompoundObjectStream : OWAbstractObjectStream
{
    OWAbstractObjectStream *framingStream;
    OWAbstractObjectStream *interjectedStream;

    unsigned int interjectedAtIndex;
}

/* a convenience method */
+ (OWObjectStreamCursor *)cursorAtCursor:(OWObjectStreamCursor *)aCursor beforeStream:(OWAbstractObjectStream *)interjectMe;

/* designated initializer */
- initWithStream:(OWAbstractObjectStream *)aStream interjectingStream:(OWAbstractObjectStream *)anotherStream atIndex:(unsigned int)index;

/* raises an exception if aStream is not a (possibly indirect) member of this compound object stream */
- (unsigned int)translateIndex:(unsigned int)index fromStream:(OWAbstractObjectStream *)aStream;

@end
