// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OIF/OIBitmapImageProcessor.h,v 1.6 1999/03/30 22:04:35 kc Exp $

#import "OIImageProcessor.h"

@class NSBitmapImageRep;

#define OIBitmapImageProcessor_MaxPlanes 5

@interface OIBitmapImageProcessor : OIImageProcessor
{
    // output storage
    unsigned int numberOfPlanes;
    BOOL isPlanar;
    unsigned char *imageDataPlanes[OIBitmapImageProcessor_MaxPlanes];
    NSBitmapImageRep *resultImageRep;
}

- (void)setImageRep:(NSBitmapImageRep *)imageRep;
- (NSBitmapImageRep *)imageRep;

- (unsigned char **)imageDataPlanes;

@end
