// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OIF/OIAnimation.h,v 1.10 1999/03/30 21:26:49 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSLock;
@class NSMutableArray;
@class OIAnimationInstance;
@class OIAnimationFrame;
@class OIImage;

#define OIAnimationInfiniteLoopCount ((unsigned int)~0)

@interface OIAnimation : OWAbstractContent
{
    NSMutableArray *frames;
    unsigned int loopCount;
    NSMutableArray *waitingInstances;
    BOOL haveAllFrames;
    NSLock *lock;
}

- initWithLoopCount:(unsigned int)loops;

- (void)addFrame:(OIAnimationFrame *)frame;
- (void)endFrames;

- (OIImage *)animationInstance; // each call returns new instance 

- (unsigned int)loopCount;
- (void)animationInstance:(OIAnimationInstance *)instance wantsFrame:(unsigned int)frameNumber;

@end
