/* OSCSIUnitDescription.h created by bungi on Mon 22-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

@class OSCSIGeneric;

typedef enum _OSCSIPeripheralType {
    OSCSIHardDrivePeripheralType        = 0x00,
    OSCSITapePeripheralType             = 0x01,
    OSCSIPrinterPeripheralType          = 0x02,
    OSCSIProcessorPeripheralType        = 0x03,
    OSCSIWriteOncePeripheralType        = 0x04,
    OSCSICDROMPeripheralType            = 0x05,
    OSCSIScannerPeripheralType          = 0x06,
    OSCSIOpticalMemoryPeripheralType    = 0x07,
    OSCSIMediumChangerPerihperalType    = 0x08,
    OSCSICommunicationsPeripheralType   = 0x09,
    OSCSIRAIDPeripheralType             = 0x0C,
    OSCSIEncloserPeripheralType         = 0x0D,
    OSCSIUnknownPeripheralType          = 0x1F
} OSCSIPeripheralType;

typedef enum _OSCSIVersion {
    OSCSINoVersion       = 0x0,
    OSCSIObsoleteVersion = 0x1,
    OSCSI2Version        = 0x2,
    OSCSI3Version        = 0x3
} OSCSIVersion;

typedef enum _OSCSIResponseFormat {
    OSCSI1ResponseFormat     = 0x0,
    OSCSIATAPIResponseFormat = 0x1,
    OSCSI2or3ResponseFormat  = 0x2
} OSCSIResponseFormat;

typedef enum _OSCSIUnitComparisonResult {
    OSCSIDifferentUnit,   // Nothing matches
    OSCSISameUnitVendor,  // The unit is made by the same vendor
    OSCSISameUnitProduct, // The unit is made by the same vendor and has the same product name
    OSCSISameUnit         // The unit is exactly the same
} OSCSIUnitComparisonResult;

@interface OSCSIUnitDescription : OFObject <NSCoding>
{
    NSString            *_vendorIdentification;
    NSString            *_productIdentification;
    NSString            *_productRevisionLevel;
    BOOL                 _mediaIsRemovable;
    OSCSIPeripheralType  _peripheralType;
    OSCSIVersion         _version;
    OSCSIResponseFormat  _responseFormat;
}

- initWithGeneric: (OSCSIGeneric *) generic;
- (id)initWithArchivePropertyList:(id)propertyList;

- (OSCSIPeripheralType) peripheralType;
- (BOOL) mediaIsRemovable;

- (OSCSIVersion) version;
- (OSCSIResponseFormat) responseFormat;

- (NSString *) peripheralTypeName;

- (NSString *) vendorIdentification;
- (NSString *) productIdentification;
- (NSString *) productRevisionLevel;

- (NSString *) unitDisplayName;

// This is intended to help one find a unit that is similar to a unit that had previously
// been found.  There isn't yet a generic way to build a unit description qualifier.
- (OSCSIUnitComparisonResult) compareToUnitDescription: (OSCSIUnitDescription *) unitDescription;
                                                         
// Archiving
- (id)archivePropertyList;

@end
