/* OSCSIUnit.h created by bungi on Sun 21-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

@class OSCSIGeneric, OSCSITarget, OSCSIUnitDescription, OSCSIResponse;

typedef unsigned long long OSCSIUnitNumberType;
typedef unsigned int       OSCSILogicalBlockAddress;

@interface OSCSIUnit : OFObject
{
    OSCSITarget          *_nonretained_target;
    OSCSIUnitNumberType   _unitNumber;

    // This is only non-nil when the instance is 'open'
    OSCSIGeneric         *_generic;

    OSCSIUnitDescription *_unitDescription;
    BOOL                  _mediaPresent;
}

+ (NSArray *) classesForUnitDescription: (OSCSIUnitDescription *) unitDescription;
+ (Class) bestClassForUnitDescription: (OSCSIUnitDescription *) unitDescription;

+ (NSString *) displayName;

- initWithTarget: (OSCSITarget *) target
      unitNumber: (OSCSIUnitNumberType) unitNumber
 unitDescription: (OSCSIUnitDescription *) unitDescription;

- (void) open;
- (void) close;
- (BOOL) isOpen;

- (OSCSITarget *) target;
- (OSCSIUnitNumberType) unitNumber;

- (OSCSIUnitDescription *) unitDescription;

- (OSCSIResponse *) testUnitReady;
- (BOOL) mediaIsPresent;
- (void) mediaInserted;
- (void) mediaRemoved;
- (void) setAllowsMediaRemoval: (BOOL) yn;
- (void) requestMedia;
- (void) eject;

@end
