/* OSCSITarget.h created by bungi on Sun 21-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

#import "OSCSIUnit.h" // For OSCSIUnitNumberType
#import "OSCSIBus.h"  // For OSCSIBusNumberType

@class OSCSIBus;

typedef unsigned long long OSCSITargetNumberType;

// If this is used when initializing the OSCSITarget, it will only
// use the raw device (instead of the generic device).  This is
// useful when you don't want to scan the bus to find the SCSI
// target or when the device is an ATAPI device (and doesn't have
// a bus/target/unit).
#define OSCSI_INVALID_TARGET_NUMBER ((OSCSITargetNumberType)-1)

@interface OSCSITarget : OFObject
{
    NSString              *_rawDeviceName;
    OSCSIBusNumberType     _busNumber;
    OSCSITargetNumberType  _targetNumber;
    NSArray               *_units;
    
}

- initWithBusNumber: (OSCSIBusNumberType) busNumber
       targetNumber: (OSCSITargetNumberType) targetNumber;

// This initializer can be used when the raw device name is known before
// the device is queries.  The only currently known case where this is
// valid/useful is when scanning for ATAPI devices.
- initWithBusNumber: (OSCSIBusNumberType) busNumber
       targetNumber: (OSCSITargetNumberType) targetNumber
      rawDeviceName: (NSString *) rawDeviceName;

// After the target is initialized and the type of target is known
// this must be set to the path to the raw Unix device.
- (void) setRawDeviceName: (NSString *) rawDeviceName;
- (NSString *) rawDeviceName;

- (OSCSIBusNumberType) busNumber;
- (OSCSITargetNumberType) targetNumber;

- (NSArray *) units;
- (OSCSIUnit *) unitWithUnitNumber: (OSCSIUnitNumberType) unitNumber;


@end
