/* OSCSIResponse.h created by bungi on Mon 22-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

@interface OSCSIResponse : OFObject
{
    unsigned int _statusByte;
    unsigned int _driverStatus;
    
    unsigned int _senseKey;
    unsigned int _additionalSenseCode;
    unsigned int _additionalSenseCodeQualifier;
    int          _bytesNotTransfered;
}

+ (OSCSIResponse *) goodResponse;

- initWithStatusByte: (unsigned int) statusByte
        driverStatus: (unsigned int) driverStatus
            senseKey: (unsigned int) senseKey
 additionalSenseCode: (unsigned int) additionalSenseCode
additionalSenseCodeQualifier: (unsigned int) additionalSenseCodeQualifier
  bytesNotTransfered: (int) bytesNotTransfered;

- (BOOL) isError;

- (unsigned int) statusByte;
- (unsigned int) driverStatus;

- (unsigned int) senseKey;
- (unsigned int) additionalSenseCode;
- (unsigned int) additionalSenseCodeQualifier;

- (int) bytesNotTransfered;

- (NSString *) errorString;

//
// Some special error checks
//
- (BOOL) isMediaMissingError;

@end
