/* OSCSIGeneric.h created by bungi on Sun 21-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

#import "OSCSITarget.h"  // For OSCSITargetNumberType
#import "OSCSIUnit.h"    // For OSCSIUnitNumberType

#import "FrameworkDefines.h"

@class OSCSIResponse;


OmniSCSI_EXTERN NSString *OSCSINoAvailableDeviceException;
OmniSCSI_EXTERN NSString *OSCSIIOException;
OmniSCSI_EXTERN NSString *OSCSIBadRawDeviceException;
OmniSCSI_EXTERN NSString *OSCSIGenericNoRawDeviceNameException;
OmniSCSI_EXTERN NSString *OSCSINoSuchBusException;
OmniSCSI_EXTERN NSString *OSCSINoSuchAddressException;

@interface OSCSIGeneric : OFObject
{
    OSCSIBusNumberType    _busNumber;
    OSCSITargetNumberType _targetNumber;
    OSCSIUnitNumberType   _unitNumber;
    unsigned int          _timeout;
    
    int                   _deviceIndex;
    int                   _genericFD;       // /dev/sgN, N = _deviceIndex

    NSString             *_rawDeviceName;
    int                   _rawFD;    // -1 initially

    int                   _currentFD; // Either -1, _genericFD or _rawFD.
}

+ (OSCSIBusNumberType) numberOfBusses;

+ (void) setDefaultTimeout: (unsigned int) timeout;
+ (unsigned int) defaultTimeout;

+ (unsigned int) maximumTargetsPerBus;

// For sg/rsd st/rst access.  If 'target' is -1, the 'sg' access will not be used ('unit' will be ignored).
- initWithBusNumber: (OSCSIBusNumberType) busNumber
       targetNumber: (OSCSITargetNumberType) targetNumber
         unitNumber: (OSCSIUnitNumberType) unitNumber;

// After the sg device is used to determine the type of device, you must set the rawDeviceName.
// This is of the form '/dev/rsdNh' for disks and '/dev/rstN' for tapes.
// Some more generic means of setting these should be made.
- (void) setRawDeviceName: (NSString *) rawDeviceName;
- (NSString *) rawDeviceName;

- (OSCSIBusNumberType) busNumber;
- (OSCSITargetNumberType) targetNumber;
- (OSCSIUnitNumberType) unitNumber;

- (void) setTimeout: (unsigned int) timeout;
- (unsigned int) timeout;

- (BOOL) useRaw;
- (void) closeRaw;

- (BOOL) useGeneric;

- (void) requestMedia;
- (void) eject;

//
// Coverse for the generic SCSI CDB sizes.  Rather than using the structures
// we'll just pass the bytes as needed.  This is useful in many cases since
// otherwise we'd need to write two versions of the code (big and little endian).
// The structs are sometimes written to be correct/useful, but often they aren't.
//

// 6-byte commands
- (OSCSIResponse *) newResponseByWritingData: (NSData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4;

- (OSCSIResponse *) newResponseByReadingData: (NSMutableData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4;

// 10-byte commands
- (OSCSIResponse *) newResponseByWritingData: (NSData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4
                                        arg5: (unsigned char) arg5
                                        arg6: (unsigned char) arg6
                                        arg7: (unsigned char) arg7
                                        arg8: (unsigned char) arg8;

- (OSCSIResponse *) newResponseByReadingData: (NSMutableData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4
                                        arg5: (unsigned char) arg5
                                        arg6: (unsigned char) arg6
                                        arg7: (unsigned char) arg7
                                        arg8: (unsigned char) arg8;

// 12-byte commands
- (OSCSIResponse *) newResponseByWritingData: (NSData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4
                                        arg5: (unsigned char) arg5
                                        arg6: (unsigned char) arg6
                                        arg7: (unsigned char) arg7
                                        arg8: (unsigned char) arg8
                                        arg9: (unsigned char) arg9
                                       arg10: (unsigned char) arg10;


- (OSCSIResponse *) newResponseByReadingData: (NSMutableData *) data
                                      opcode: (unsigned char) opcode
                                        name: (unsigned char *) name
                                        arg1: (unsigned char) arg1
                                        arg2: (unsigned char) arg2
                                        arg3: (unsigned char) arg3
                                        arg4: (unsigned char) arg4
                                        arg5: (unsigned char) arg5
                                        arg6: (unsigned char) arg6
                                        arg7: (unsigned char) arg7
                                        arg8: (unsigned char) arg8
                                        arg9: (unsigned char) arg9
                                       arg10: (unsigned char) arg10;



@end
