/* OSCSICDAudioTableOfContents.h created by bungi on Tue 23-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

#import "OSCSIUnit.h" // For OSCSILogicalBlockAddress

// This can be used to find the start time of the lead out track,
// that is the time at which the disc ends.
#define OSCSI_LEAD_OUT_TRACK (0xAA)

// This is pretty simplistic right now, but later it will encompass more
// info -- enough to burn CDs.
typedef struct _OSCSICDAudioTrackDescription {
    unsigned int             trackNumber;
    OSCSILogicalBlockAddress startingLBA;
} OSCSICDAudioTrackDescription;


@interface OSCSICDAudioTableOfContents : OFObject
{
    unsigned int                  _descriptionCount;
    OSCSICDAudioTrackDescription *_trackDescriptions;
}

- initWithTrackDescriptions: (OSCSICDAudioTrackDescription *) descriptions
                      count: (unsigned int) descriptionCount;
// The 'descriptions' must be NSZoneMalloced memory.  The receive owns the
// memory passed to it.  The descriptions must be in ascending order.

- (unsigned int) numberOfTracks;
// Not necessarily the same as _descriptionCount

- (unsigned int) trackContainingLBA: (OSCSILogicalBlockAddress) lba;

- (OSCSILogicalBlockAddress) startingLBAForTrackNumber: (unsigned int) trackNumber;
- (OSCSILogicalBlockAddress) endingLBAForTrackNumber: (unsigned int) trackNumber;

@end
