/* OSCSICDAudioProtocols.h created by bungi on Tue 23-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

#import "OSCSIUnit.h" // For OSCSILogicalBlockAddress
#import "FrameworkDefines.h"

@class OSCSICDAudioTableOfContents;

OmniSCSI_EXTERN NSString *OSCSICDAudioUnitTableOfContentsChangedNotification;

// This should be used as the beginning of the play position
// to simply continue or start playing from the current position.
#define OSCSI_USE_CURRENT_PLAY_POSITION (0xffffffff)

#define OSCSI_CDDA_FRAMES_PER_SECOND (75)

typedef enum _OSCSICDAudioStatus {
    OSCSICDAudioUnknownStatus,
    OSCSICDAudioIdleStatus,
    OSCSICDAudioPlayingStatus,
    OSCSICDAudioPausedStatus,
    OSCSICDAudioScanningStatus
} OSCSICDAudioStatus;

@protocol OSCSICDRomAudioControl
- (void) updateStatus;

- (BOOL) mediaPresent;
- (void) unloadMedia;

- (OSCSICDAudioTableOfContents *) tableOfContents;

- (void) startPlayingLBARange: (NSRange) lbaRange;
- (void) stopPlaying;
- (void) setAudioIsPaused: (BOOL) paused;

- (OSCSILogicalBlockAddress) currentLBA;
- (OSCSICDAudioStatus) currentStatus;

@end

@protocol OSCSICDRomAudioIdentification
- (NSString *) mediaCatalogueNumber;
- (NSString *) internationalStandardRecordingCodeForTrack: (unsigned char) trackNumber;
@end

@protocol OSCSICDRomAudioVolumeControl
// The percentage here should be a number between 0 and 1.
- (float) leftVolumePercentage;
- (float) rightVolumePercentage;
- (void) setLeftVolumePercentage: (float) leftPercentage
           rightVolumePercentage: (float) rightPercentage;
@end

@protocol OSCSICDRomAudioScan
- (void) startScanningFromLBA: (OSCSILogicalBlockAddress) lba
                      forward: (BOOL) forward;
- (void) stopScanningAndResumePlayingUntilLBA: (OSCSILogicalBlockAddress) lba;
@end



typedef struct _OSCSIMinuteSecondsFrames {
    unsigned char minutes;
    unsigned char seconds;
    unsigned char frames;
} OSCSIMinuteSecondsFrames;


// LBA of 0 -> MSF 00:00:00
static inline OSCSIMinuteSecondsFrames OSCSIRelativeLogicalBlockAddressToMinutesSecondsFrames(OSCSILogicalBlockAddress lba)
{
    OSCSIMinuteSecondsFrames msf;

    msf.minutes = lba / (60 * OSCSI_CDDA_FRAMES_PER_SECOND);
    lba %= (60 * OSCSI_CDDA_FRAMES_PER_SECOND);

    msf.seconds = lba / OSCSI_CDDA_FRAMES_PER_SECOND;
    msf.frames = lba % OSCSI_CDDA_FRAMES_PER_SECOND;

    return msf;
}

// LBA of 0 -> MSF 00:02:00
static inline OSCSIMinuteSecondsFrames OSCSIAbsoluteLogicalBlockAddressToMinutesSecondsFrames(OSCSILogicalBlockAddress lba)
{
    return OSCSIRelativeLogicalBlockAddressToMinutesSecondsFrames(lba + 2 * OSCSI_CDDA_FRAMES_PER_SECOND);
}
