/* OSCSIBus.h created by bungi on Sun 21-Jun-1998 */

#import <OmniFoundation/OmniFoundation.h>

#import "OSCSIUnitDescription.h"

@class OSCSITarget;

typedef unsigned int OSCSIBusNumberType;

// If this is used when initializing the OSCSITarget, it will only
// use the raw device (instead of the generic device).  This is
// useful when you don't want to scan the bus to find the SCSI
// target or when the device is an ATAPI device (and doesn't have
// a bus/target/unit).
#define OSCSI_INVALID_BUS_NUMBER ((OSCSIBusNumberType)-1)

@interface OSCSIBus : OFObject
{
    OSCSIBusNumberType  _busNumber;
    NSArray            *_targets;
}

+ (NSArray *) busses;
+ (OSCSIBus *) busWithBusNumber: (OSCSIBusNumberType) busNumber;

- (OSCSIBusNumberType) busNumber;

- (NSArray *) targets;
- (OSCSITarget *) targetWithTargetNumber: (unsigned int) target;
- (OSCSITarget *) targetWithRawDeviceName: (NSString *) deviceName;

- (NSArray *) allUnitsWithPeripheralType: (OSCSIPeripheralType) peripheralType;

- (void) reset;

@end
