// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "ONInternetSocket.h"

@interface ONTCPSocket : ONInternetSocket

+ (Class)defaultTCPSocketClass;
+ (void)setDefaultTCPSocketClass:(Class)aClass;

+ (ONTCPSocket *)tcpSocket;
    // This creates a socket of the defaultTCPSocketClass

- (void)startListeningOnAnyLocalPort;
- (void)startListeningOnLocalPort:(unsigned short int)port;
- (void)startListeningOnLocalService:(ONServiceEntry *)service;

- (void)acceptConnection;
- (ONTCPSocket *)acceptConnectionOnNewSocket;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONTCPSocketListenFailedExceptionName;
OmniNetworking_EXTERN NSString *ONTCPSocketAcceptFailedExceptionName;
