// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniBase/OBObject.h>

@class NSData;
@class NSMutableData;
@class NSString;
@class ONSocket;

#import <Foundation/NSString.h> // For NSStringEncoding

@interface ONSocketStream : OBObject
{
    ONSocket *socket;
    NSMutableData *readBuffer;
}

+ streamWithSocket:(ONSocket *)aSocket;
- initWithSocket:(ONSocket *)aSocket;
- (ONSocket *)socket;

- (void)setReadBuffer:(NSMutableData *)aData;
- (void)clearReadBuffer;
- (void)advanceReadBufferBy:(unsigned int)advanceAmount;

- (NSData *)readData;
- (NSData *)readDataOfLength:(unsigned int)length;

- (NSString *)readString;
    // Note:  not currently reliable if the stringEncoding is set to a multibyte encoding

- (NSString *)readLineAndAdvance:(BOOL)shouldAdvance;
- (NSString *)readLine;
- (NSString *)peekLine;

- (void)writeString:(NSString *)aString;
- (void)writeFormat:(NSString *)aFormat, ...;
- (void)writeData:(NSData *)theData;

- (NSStringEncoding)stringEncoding;
- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;

@end
