// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniBase/OBObject.h>

@class NSData;
@class NSMutableData;

#import <Foundation/NSString.h> // for NSStringEncoding

@interface ONSocket : OBObject
{
    NSStringEncoding stringEncoding;
    unsigned int readBufferSize;
}

// These are the primitive methods which must be implemented by subclasses
- (unsigned int)readBytes:(unsigned int)byteCount intoBuffer:(void *)aBuffer;
- (unsigned int)writeBytes:(unsigned int)byteCount fromBuffer:(const void *)aBuffer;
- (void)abortSocket;

@end

@interface ONSocket (General)

// These methods operate in terms of the primitive methods, and therefore need not be implemented by subclasses.

+ (void)setDefaultStringEncoding:(NSStringEncoding)aStringEncoding;
+ (void)setDefaultReadBufferSize:(int)aSize;

- (void)writeData:(NSData *)data;
- (void)writeString:(NSString *)aString;
- (void)writeFormat:(NSString *)aFormat, ...;
- (void)readData:(NSMutableData *)data;
- (NSData *)readData;
- (NSString *)readString;

- (NSStringEncoding)stringEncoding;
- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;
- (void)setReadBufferSize:(int)aSize;

@end
