// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniBase/OBObject.h>

#import "FrameworkDefines.h"

@interface ONServiceEntry : OBObject
{
    NSString *serviceName;
    NSString *protocolName;
    struct servent *serviceEntry;
}

+ serviceEntryNamed:(NSString *)aServiceName protocolName:(NSString *)aProtocolName;

- (NSString *)serviceName;
- (NSString *)protocolName;
- (unsigned short int)portNumber;

- (const struct servent *)serviceEntry;

@end

// This is not an exhaustive list, but more than most people will ever use
OmniNetworking_EXTERN NSString *ONServiceEntryIPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryICMPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryTCPProtocolName;
OmniNetworking_EXTERN NSString *ONServiceEntryUDPProtocolName;

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONServiceNotFoundExceptionName;
